/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.statistical.StandardDeviation;
import trade.invision.num.Num;

public class StandardError
extends Indicator<Num> {
    private static final Cache<CacheKey, StandardError> CACHE = Caffeine.newBuilder().weakValues().build();
    private final int length;
    private final StandardDeviation standardDeviation;

    public static StandardError stderr(Indicator<Num> indicator, int length, boolean unbiased) {
        return StandardError.standardError(indicator, length, unbiased);
    }

    public static StandardError standardError(Indicator<Num> indicator, int length, boolean unbiased) {
        return (StandardError)CACHE.get((Object)new CacheKey(indicator, length, unbiased), key -> new StandardError(indicator, length, unbiased));
    }

    protected StandardError(Indicator<Num> indicator, int length, boolean unbiased) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.length = length;
        this.standardDeviation = StandardDeviation.standardDeviation(indicator, length, unbiased);
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        return ((Num)this.standardDeviation.getValue(index)).divide(this.numOf(observations).squareRoot());
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, boolean unbiased) {
            this.indicator = indicator;
            this.length = length;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StandardError.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

