/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ma.sma.SimpleMovingAverage;
import trade.invision.num.Num;

public class Variance
extends Indicator<Num> {
    private static final Cache<CacheKey, Variance> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int length;
    private final boolean unbiased;
    private final SimpleMovingAverage sma;

    public static Variance var(Indicator<Num> indicator, int length, boolean unbiased) {
        return Variance.variance(indicator, length, unbiased);
    }

    public static Variance variance(Indicator<Num> indicator, int length, boolean unbiased) {
        return (Variance)CACHE.get((Object)new CacheKey(indicator, length, unbiased), key -> new Variance(indicator, length, unbiased));
    }

    protected Variance(Indicator<Num> indicator, int length, boolean unbiased) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
        this.unbiased = unbiased;
        this.sma = SimpleMovingAverage.simpleMovingAverage(indicator, length);
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        Num average = (Num)this.sma.getValue(index);
        Num variance = this.numOfZero();
        for (long indicatorIndex = startIndex; indicatorIndex <= index; ++indicatorIndex) {
            variance = variance.add(this.indicator.getValue(indicatorIndex).subtract(average).square());
        }
        return variance.divide((Number)(this.unbiased ? Math.max(1L, observations - 1L) : observations));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, boolean unbiased) {
            this.indicator = indicator;
            this.length = length;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Variance.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

