/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.statistical.regression;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.cumulative.CumulativeSum;
import trade.invision.indicators.indicator.meta.indicator.CurrentIndex;
import trade.invision.indicators.indicator.operation.unary.UnaryOperation;
import trade.invision.indicators.indicator.statistical.regression.LinearRegressionResult;
import trade.invision.indicators.indicator.statistical.regression.LinearRegressionResultType;
import trade.invision.num.Num;

public class LinearRegression
extends Indicator<LinearRegressionResult> {
    private static final Cache<CacheKey, LinearRegression> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final Set<LinearRegressionResultType> resultTypes;
    private final int length;
    private final CumulativeSum sumX;
    private final CumulativeSum sumY;

    public static Indicator<Num> linearRegressionSlope(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getSlope, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.SLOPE), length));
    }

    public static Indicator<Num> linearRegressionIntercept(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getIntercept, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.INTERCEPT), length));
    }

    public static Indicator<Num> linearRegressionY(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getY, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.Y), length));
    }

    public static Indicator<Num> linearRegressionNextY(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getNextY, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.NEXT_Y), length));
    }

    public static Indicator<Num> linearRegressionRss(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getRss, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.RSS), length));
    }

    public static Indicator<Num> linearRegressionTss(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getTss, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.TSS), length));
    }

    public static Indicator<Num> linearRegressionR2(Indicator<Num> indicator, int length) {
        return UnaryOperation.unaryOperation(LinearRegressionResult::getR2, LinearRegression.linearRegression(indicator, Set.of(LinearRegressionResultType.R2), length));
    }

    public static synchronized LinearRegression linearRegression(Indicator<Num> indicator, Set<LinearRegressionResultType> resultTypes, int length) {
        CacheKey cacheKey = new CacheKey(indicator, length);
        LinearRegression linearRegression = (LinearRegression)CACHE.getIfPresent((Object)cacheKey);
        if (linearRegression == null) {
            linearRegression = new LinearRegression(indicator, resultTypes, length);
            CACHE.put((Object)cacheKey, (Object)linearRegression);
        } else {
            linearRegression.resultTypes.addAll(resultTypes);
            linearRegression.purgeCache();
        }
        return linearRegression;
    }

    protected LinearRegression(Indicator<Num> indicator, Set<LinearRegressionResultType> resultTypes, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        Preconditions.checkArgument((!resultTypes.isEmpty() ? 1 : 0) != 0, (Object)"'resultTypes' must not be empty!");
        this.indicator = indicator.caching();
        this.resultTypes = new HashSet<LinearRegressionResultType>(resultTypes);
        this.length = length;
        this.sumX = CumulativeSum.cumulativeSum(CurrentIndex.currentIndex(this.series), length);
        this.sumY = CumulativeSum.cumulativeSum(indicator, length);
    }

    @Override
    protected LinearRegressionResult calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        Num xBar = ((Num)this.sumX.getValue(index)).divide((Number)observations);
        Num yBar = ((Num)this.sumY.getValue(index)).divide((Number)observations);
        Num xxBar = this.numOfZero();
        Num xyBar = this.numOfZero();
        for (long indicatorIndex = startIndex; indicatorIndex <= index; ++indicatorIndex) {
            Num xDelta = this.numOf(indicatorIndex).subtract(xBar);
            xxBar = xxBar.add(xDelta.square());
            xyBar = xyBar.add(xDelta.multiply(this.indicator.getValue(indicatorIndex).subtract(yBar)));
        }
        LinearRegressionResult.LinearRegressionResultBuilder result = LinearRegressionResult.builder();
        Num slope = xyBar.divide(xxBar).ifNaN(this.numOfZero());
        result.slope(slope);
        Num intercept = yBar.subtract(slope.multiply(xBar));
        result.intercept(intercept);
        if (this.resultTypes.contains((Object)LinearRegressionResultType.Y)) {
            result.y(slope.multiply((Number)index).add(intercept));
        }
        if (this.resultTypes.contains((Object)LinearRegressionResultType.NEXT_Y)) {
            result.nextY(slope.multiply((Number)(index + 1L)).add(intercept));
        }
        if (this.resultTypes.contains((Object)LinearRegressionResultType.RSS) || this.resultTypes.contains((Object)LinearRegressionResultType.TSS) || this.resultTypes.contains((Object)LinearRegressionResultType.R2)) {
            Num rss = this.numOfZero();
            Num tss = this.numOfZero();
            for (long indicatorIndex = startIndex; indicatorIndex <= index; ++indicatorIndex) {
                Num y = this.indicator.getValue(indicatorIndex);
                Num fit = slope.multiply((Number)indicatorIndex).add(intercept);
                rss = rss.add(fit.subtract(y).square());
                tss = tss.add(y.subtract(yBar).square());
            }
            result.rss(rss);
            result.tss(tss);
            if (this.resultTypes.contains((Object)LinearRegressionResultType.R2)) {
                result.r2(this.numOfOne().subtract(rss.divide(tss).ifNaN(this.numOfZero())));
            }
        }
        return result.build();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LinearRegression.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

