/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

public class UlcerIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, UlcerIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int length;

    public static UlcerIndex ui(Indicator<Num> indicator, int length) {
        return UlcerIndex.ulcerIndex(indicator, length);
    }

    public static UlcerIndex ulcerIndex(Indicator<Num> indicator, int length) {
        return (UlcerIndex)CACHE.get((Object)new CacheKey(indicator, length), key -> new UlcerIndex(indicator, length));
    }

    protected UlcerIndex(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator;
        this.length = length;
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        Num highestValue = null;
        Num meanSquare = this.numOfZero();
        for (long indicatorIndex = startIndex + 1L; indicatorIndex <= index; ++indicatorIndex) {
            Num value = this.indicator.getValue(indicatorIndex);
            if (highestValue == null || value.isGreaterThan(highestValue)) {
                highestValue = value;
            }
            meanSquare = meanSquare.add(value.divide(highestValue).decrement().multiply(this.numOfHundred())).square();
        }
        return meanSquare.divide((Number)observations).squareRoot();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UlcerIndex.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

