/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.wpr;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.extrema.local.LocalMaximum;
import trade.invision.indicators.indicator.extrema.local.LocalMinimum;
import trade.invision.num.Num;

public class WilliamsPercentRange
extends Indicator<Num> {
    private static final Cache<CacheKey, WilliamsPercentRange> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final LocalMaximum highestHigh;
    private final LocalMinimum lowestLow;
    private final Num negativeHundred;

    public static WilliamsPercentRange wpr(Indicator<Num> indicator, int length) {
        return WilliamsPercentRange.williamsPercentRange(indicator, length);
    }

    public static WilliamsPercentRange williamsPercentRange(Indicator<Num> indicator, int length) {
        return (WilliamsPercentRange)CACHE.get((Object)new CacheKey(indicator, length), key -> new WilliamsPercentRange(indicator, length));
    }

    protected WilliamsPercentRange(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator;
        this.highestHigh = LocalMaximum.localMaximum(indicator, length);
        this.lowestLow = LocalMinimum.localMinimum(indicator, length);
        this.negativeHundred = this.numOf(-100);
    }

    @Override
    protected Num calculate(long index) {
        Num value = this.indicator.getValue(index);
        Num highestHighValue = (Num)this.highestHigh.getValue(index);
        Num lowestLowValue = (Num)this.lowestLow.getValue(index);
        return highestHighValue.subtract(value).divide(highestHighValue.subtract(lowestLowValue)).multiply(this.negativeHundred);
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WilliamsPercentRange.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

