/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.barprice;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class Ohlc4
extends Indicator<Num> {
    private static final Cache<CacheKey, Ohlc4> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;

    public static Ohlc4 averagePrice(BarSeries barSeries) {
        return Ohlc4.ohlc4(barSeries);
    }

    public static Ohlc4 ohlc4(BarSeries barSeries) {
        return (Ohlc4)CACHE.get((Object)new CacheKey(barSeries), key -> new Ohlc4(barSeries));
    }

    protected Ohlc4(BarSeries barSeries) {
        super(barSeries, 0);
        this.barSeries = barSeries;
    }

    @Override
    protected Num calculate(long index) {
        Bar bar = (Bar)this.barSeries.get(index);
        return bar.getOpen().add(bar.getHigh()).add(bar.getLow()).add(bar.getClose()).divide(this.numOfFour());
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Ohlc4.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

