/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.bullishbearish.local;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

abstract class AbstractLocalBullishBearishPercentage
extends Indicator<Num> {
    private final BarSeries barSeries;
    private final int length;
    private final Predicate<Bar> predicate;

    protected AbstractLocalBullishBearishPercentage(BarSeries barSeries, int length, boolean bullish) {
        super(barSeries, 0);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.barSeries = barSeries;
        this.length = length;
        this.predicate = bullish ? Bar::isBullish : Bar::isBearish;
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        int count = 0;
        for (long seriesIndex = startIndex; seriesIndex <= index; ++seriesIndex) {
            if (!this.predicate.test((Bar)this.barSeries.get(seriesIndex))) continue;
            ++count;
        }
        return this.numOf(count).divide((Number)observations);
    }
}

