/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.iii;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class IntradayIntensityIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, IntradayIntensityIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;

    public static IntradayIntensityIndex iii(BarSeries barSeries) {
        return IntradayIntensityIndex.intradayIntensityIndex(barSeries);
    }

    public static IntradayIntensityIndex intradayIntensityIndex(BarSeries barSeries) {
        return (IntradayIntensityIndex)CACHE.get((Object)new CacheKey(barSeries), key -> new IntradayIntensityIndex(barSeries));
    }

    protected IntradayIntensityIndex(BarSeries barSeries) {
        super(barSeries, 0);
        this.barSeries = barSeries;
    }

    @Override
    protected Num calculate(long index) {
        Bar bar = (Bar)this.barSeries.get(index);
        Num close = bar.getClose();
        Num high = bar.getHigh();
        Num low = bar.getLow();
        Num volume = bar.getVolume();
        return this.numOfTwo().multiply(close).subtract(high).subtract(low).divide(high.subtract(low).multiply(volume));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IntradayIntensityIndex.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

