/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.instant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;

public class WithDateTimeField
extends Indicator<Instant> {
    private static final Cache<CacheKey, WithDateTimeField> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Instant> base;
    private final Indicator<Instant> reference;
    private final ChronoField field;
    private final ZoneId zoneId;

    public static WithDateTimeField withDateTimeField(Indicator<Instant> base, Indicator<Instant> reference, ChronoField field) {
        return WithDateTimeField.withDateTimeField(base, reference, field, ZoneOffset.UTC);
    }

    public static WithDateTimeField withDateTimeField(Indicator<Instant> base, Indicator<Instant> reference, ChronoField field, ZoneId zoneId) {
        return (WithDateTimeField)CACHE.get((Object)new CacheKey(base, reference, field, zoneId), key -> new WithDateTimeField(base, reference, field, zoneId));
    }

    protected WithDateTimeField(Indicator<Instant> base, Indicator<Instant> reference, ChronoField field, ZoneId zoneId) {
        super(base.getSeries(), 0);
        this.base = base;
        this.reference = reference;
        this.field = field;
        this.zoneId = zoneId;
    }

    @Override
    protected Instant calculate(long index) {
        return this.base.getValue(index).atZone(this.zoneId).with(this.field, this.reference.getValue(index).atZone(this.zoneId).get(this.field)).toInstant();
    }

    private static final class CacheKey {
        private final Indicator<Instant> base;
        private final Indicator<Instant> reference;
        private final ChronoField field;
        private final ZoneId zoneId;

        @Generated
        public CacheKey(Indicator<Instant> base, Indicator<Instant> reference, ChronoField field, ZoneId zoneId) {
            this.base = base;
            this.reference = reference;
            this.field = field;
            this.zoneId = zoneId;
        }

        @Generated
        public Indicator<Instant> getBase() {
            return this.base;
        }

        @Generated
        public Indicator<Instant> getReference() {
            return this.reference;
        }

        @Generated
        public ChronoField getField() {
            return this.field;
        }

        @Generated
        public ZoneId getZoneId() {
            return this.zoneId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Instant> this$base = this.getBase();
            Indicator<Instant> other$base = other.getBase();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            Indicator<Instant> this$reference = this.getReference();
            Indicator<Instant> other$reference = other.getReference();
            if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                return false;
            }
            ChronoField this$field = this.getField();
            ChronoField other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            ZoneId this$zoneId = this.getZoneId();
            ZoneId other$zoneId = other.getZoneId();
            return !(this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Instant> $base = this.getBase();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            Indicator<Instant> $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            ChronoField $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            ZoneId $zoneId = this.getZoneId();
            result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WithDateTimeField.CacheKey(base=" + String.valueOf(this.getBase()) + ", reference=" + String.valueOf(this.getReference()) + ", field=" + String.valueOf(this.getField()) + ", zoneId=" + String.valueOf(this.getZoneId()) + ")";
        }
    }
}

