/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.ma;

import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.ma.MovingAverageType;
import trade.invision.indicators.indicators.ma.ema.DoubleExponentialMovingAverage;
import trade.invision.indicators.indicators.ma.ema.ExponentialMovingAverage;
import trade.invision.indicators.indicators.ma.ema.TripleExponentialMovingAverage;
import trade.invision.indicators.indicators.ma.ema.WellesWilderMovingAverage;
import trade.invision.indicators.indicators.ma.ema.ZeroLagExponentialMovingAverage;
import trade.invision.indicators.indicators.ma.hma.HullMovingAverage;
import trade.invision.indicators.indicators.ma.kama.KaufmansAdaptiveMovingAverage;
import trade.invision.indicators.indicators.ma.lsma.LeastSquaresMovingAverage;
import trade.invision.indicators.indicators.ma.lsma.PredictiveLeastSquaresMovingAverage;
import trade.invision.indicators.indicators.ma.sma.SimpleMovingAverage;
import trade.invision.indicators.indicators.ma.wma.LinearlyWeightedMovingAverage;
import trade.invision.indicators.indicators.ma.wma.WeightedMovingAverage;
import trade.invision.num.Num;

public final class MovingAverageSupplier {
    private final MovingAverageType type;
    @Nullable
    private final Num emaSmoothing;
    @Nullable
    private final Num demaSmoothing;
    @Nullable
    private final Num temaSmoothing;
    @Nullable
    private final Integer kamaFastLength;
    @Nullable
    private final Integer kamaSlowLength;

    public static MovingAverageSupplier smaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.SMA).build();
    }

    public static MovingAverageSupplier emaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.EMA).build();
    }

    public static MovingAverageSupplier demaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.DEMA).build();
    }

    public static MovingAverageSupplier temaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.TEMA).build();
    }

    public static MovingAverageSupplier wwmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.WWMA).build();
    }

    public static MovingAverageSupplier zlemaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.ZLEMA).build();
    }

    public static MovingAverageSupplier hmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.HMA).build();
    }

    public static MovingAverageSupplier kamaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.KAMA).build();
    }

    public static MovingAverageSupplier lsmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.LSMA).build();
    }

    public static MovingAverageSupplier plsmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.PLSMA).build();
    }

    public static MovingAverageSupplier wmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.WMA).build();
    }

    public static MovingAverageSupplier lwmaSupplier() {
        return MovingAverageSupplier.builder().type(MovingAverageType.LWMA).build();
    }

    public Indicator<Num> supply(Indicator<Num> indicator, int length) {
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case MovingAverageType.SMA -> SimpleMovingAverage.sma(indicator, length);
            case MovingAverageType.EMA -> {
                if (this.emaSmoothing != null) {
                    yield ExponentialMovingAverage.ema(indicator, length, this.emaSmoothing);
                }
                yield ExponentialMovingAverage.ema(indicator, length);
            }
            case MovingAverageType.DEMA -> {
                if (this.demaSmoothing != null) {
                    yield DoubleExponentialMovingAverage.dema(indicator, length, this.demaSmoothing);
                }
                yield DoubleExponentialMovingAverage.dema(indicator, length);
            }
            case MovingAverageType.TEMA -> {
                if (this.temaSmoothing != null) {
                    yield TripleExponentialMovingAverage.tema(indicator, length, this.temaSmoothing);
                }
                yield TripleExponentialMovingAverage.tema(indicator, length);
            }
            case MovingAverageType.WWMA -> WellesWilderMovingAverage.wwma(indicator, length);
            case MovingAverageType.ZLEMA -> ZeroLagExponentialMovingAverage.zlema(indicator, length);
            case MovingAverageType.HMA -> HullMovingAverage.hma(indicator, length);
            case MovingAverageType.KAMA -> {
                if (this.kamaSlowLength != null && this.kamaFastLength != null) {
                    yield KaufmansAdaptiveMovingAverage.kama(indicator, length, this.kamaFastLength, this.kamaSlowLength);
                }
                yield KaufmansAdaptiveMovingAverage.kama(indicator, length);
            }
            case MovingAverageType.LSMA -> LeastSquaresMovingAverage.lsma(indicator, length);
            case MovingAverageType.PLSMA -> PredictiveLeastSquaresMovingAverage.plsma(indicator, length);
            case MovingAverageType.WMA -> WeightedMovingAverage.wma(indicator, length);
            case MovingAverageType.LWMA -> LinearlyWeightedMovingAverage.lwma(indicator, length);
        };
    }

    @Generated
    public static MovingAverageSupplierBuilder builder() {
        return new MovingAverageSupplierBuilder();
    }

    @Generated
    public MovingAverageSupplierBuilder toBuilder() {
        return new MovingAverageSupplierBuilder().type(this.type).emaSmoothing(this.emaSmoothing).demaSmoothing(this.demaSmoothing).temaSmoothing(this.temaSmoothing).kamaFastLength(this.kamaFastLength).kamaSlowLength(this.kamaSlowLength);
    }

    @Generated
    public MovingAverageType getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public Num getEmaSmoothing() {
        return this.emaSmoothing;
    }

    @Nullable
    @Generated
    public Num getDemaSmoothing() {
        return this.demaSmoothing;
    }

    @Nullable
    @Generated
    public Num getTemaSmoothing() {
        return this.temaSmoothing;
    }

    @Nullable
    @Generated
    public Integer getKamaFastLength() {
        return this.kamaFastLength;
    }

    @Nullable
    @Generated
    public Integer getKamaSlowLength() {
        return this.kamaSlowLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovingAverageSupplier)) {
            return false;
        }
        MovingAverageSupplier other = (MovingAverageSupplier)o;
        Integer this$kamaFastLength = this.getKamaFastLength();
        Integer other$kamaFastLength = other.getKamaFastLength();
        if (this$kamaFastLength == null ? other$kamaFastLength != null : !((Object)this$kamaFastLength).equals(other$kamaFastLength)) {
            return false;
        }
        Integer this$kamaSlowLength = this.getKamaSlowLength();
        Integer other$kamaSlowLength = other.getKamaSlowLength();
        if (this$kamaSlowLength == null ? other$kamaSlowLength != null : !((Object)this$kamaSlowLength).equals(other$kamaSlowLength)) {
            return false;
        }
        MovingAverageType this$type = this.getType();
        MovingAverageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Num this$emaSmoothing = this.getEmaSmoothing();
        Num other$emaSmoothing = other.getEmaSmoothing();
        if (this$emaSmoothing == null ? other$emaSmoothing != null : !this$emaSmoothing.equals(other$emaSmoothing)) {
            return false;
        }
        Num this$demaSmoothing = this.getDemaSmoothing();
        Num other$demaSmoothing = other.getDemaSmoothing();
        if (this$demaSmoothing == null ? other$demaSmoothing != null : !this$demaSmoothing.equals(other$demaSmoothing)) {
            return false;
        }
        Num this$temaSmoothing = this.getTemaSmoothing();
        Num other$temaSmoothing = other.getTemaSmoothing();
        return !(this$temaSmoothing == null ? other$temaSmoothing != null : !this$temaSmoothing.equals(other$temaSmoothing));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $kamaFastLength = this.getKamaFastLength();
        result = result * 59 + ($kamaFastLength == null ? 43 : ((Object)$kamaFastLength).hashCode());
        Integer $kamaSlowLength = this.getKamaSlowLength();
        result = result * 59 + ($kamaSlowLength == null ? 43 : ((Object)$kamaSlowLength).hashCode());
        MovingAverageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Num $emaSmoothing = this.getEmaSmoothing();
        result = result * 59 + ($emaSmoothing == null ? 43 : $emaSmoothing.hashCode());
        Num $demaSmoothing = this.getDemaSmoothing();
        result = result * 59 + ($demaSmoothing == null ? 43 : $demaSmoothing.hashCode());
        Num $temaSmoothing = this.getTemaSmoothing();
        result = result * 59 + ($temaSmoothing == null ? 43 : $temaSmoothing.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MovingAverageSupplier(type=" + String.valueOf((Object)this.getType()) + ", emaSmoothing=" + String.valueOf(this.getEmaSmoothing()) + ", demaSmoothing=" + String.valueOf(this.getDemaSmoothing()) + ", temaSmoothing=" + String.valueOf(this.getTemaSmoothing()) + ", kamaFastLength=" + this.getKamaFastLength() + ", kamaSlowLength=" + this.getKamaSlowLength() + ")";
    }

    @Generated
    public MovingAverageSupplier(MovingAverageType type, @Nullable Num emaSmoothing, @Nullable Num demaSmoothing, @Nullable Num temaSmoothing, @Nullable Integer kamaFastLength, @Nullable Integer kamaSlowLength) {
        this.type = type;
        this.emaSmoothing = emaSmoothing;
        this.demaSmoothing = demaSmoothing;
        this.temaSmoothing = temaSmoothing;
        this.kamaFastLength = kamaFastLength;
        this.kamaSlowLength = kamaSlowLength;
    }

    @Generated
    public static class MovingAverageSupplierBuilder {
        @Generated
        private MovingAverageType type;
        @Generated
        private Num emaSmoothing;
        @Generated
        private Num demaSmoothing;
        @Generated
        private Num temaSmoothing;
        @Generated
        private Integer kamaFastLength;
        @Generated
        private Integer kamaSlowLength;

        @Generated
        MovingAverageSupplierBuilder() {
        }

        @Generated
        public MovingAverageSupplierBuilder type(MovingAverageType type) {
            this.type = type;
            return this;
        }

        @Generated
        public MovingAverageSupplierBuilder emaSmoothing(@Nullable Num emaSmoothing) {
            this.emaSmoothing = emaSmoothing;
            return this;
        }

        @Generated
        public MovingAverageSupplierBuilder demaSmoothing(@Nullable Num demaSmoothing) {
            this.demaSmoothing = demaSmoothing;
            return this;
        }

        @Generated
        public MovingAverageSupplierBuilder temaSmoothing(@Nullable Num temaSmoothing) {
            this.temaSmoothing = temaSmoothing;
            return this;
        }

        @Generated
        public MovingAverageSupplierBuilder kamaFastLength(@Nullable Integer kamaFastLength) {
            this.kamaFastLength = kamaFastLength;
            return this;
        }

        @Generated
        public MovingAverageSupplierBuilder kamaSlowLength(@Nullable Integer kamaSlowLength) {
            this.kamaSlowLength = kamaSlowLength;
            return this;
        }

        @Generated
        public MovingAverageSupplier build() {
            return new MovingAverageSupplier(this.type, this.emaSmoothing, this.demaSmoothing, this.temaSmoothing, this.kamaFastLength, this.kamaSlowLength);
        }

        @Generated
        public String toString() {
            return "MovingAverageSupplier.MovingAverageSupplierBuilder(type=" + String.valueOf((Object)this.type) + ", emaSmoothing=" + String.valueOf(this.emaSmoothing) + ", demaSmoothing=" + String.valueOf(this.demaSmoothing) + ", temaSmoothing=" + String.valueOf(this.temaSmoothing) + ", kamaFastLength=" + this.kamaFastLength + ", kamaSlowLength=" + this.kamaSlowLength + ")";
        }
    }
}

