/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.ma.ema;

import com.google.common.base.Preconditions;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.num.Num;

abstract class AbstractExponentialMovingAverage
extends RecursiveIndicator<Num> {
    private final Indicator<Num> indicator;
    private final Num multiplier;

    protected AbstractExponentialMovingAverage(Indicator<Num> indicator, int length, Num multiplier) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator;
        this.multiplier = multiplier;
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.indicator.getValue(0L);
        }
        Num previousValue = (Num)this.getValue(index - 1L);
        return this.indicator.getValue(index).subtract(previousValue).multiply(this.multiplier).add(previousValue);
    }
}

