/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.mf.directional;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.bar.Volume;
import trade.invision.indicators.indicators.barprice.Hlc3;
import trade.invision.indicators.indicators.mf.directional.DirectionalMoneyFlowResult;
import trade.invision.indicators.indicators.operation.unary.UnaryOperation;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class DirectionalMoneyFlow
extends Indicator<DirectionalMoneyFlowResult> {
    private static final Cache<CacheKey, DirectionalMoneyFlow> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Hlc3 hlc3;
    private final Volume volume;

    public static Indicator<Num> positiveDmf(BarSeries barSeries) {
        return DirectionalMoneyFlow.positiveDirectionalMoneyFlow(barSeries);
    }

    public static Indicator<Num> positiveDirectionalMoneyFlow(BarSeries barSeries) {
        return UnaryOperation.unaryOperation(DirectionalMoneyFlowResult::getPositive, DirectionalMoneyFlow.directionalMoneyFlow(barSeries));
    }

    public static Indicator<Num> negativeDmf(BarSeries barSeries) {
        return DirectionalMoneyFlow.negativeDirectionalMoneyFlow(barSeries);
    }

    public static Indicator<Num> negativeDirectionalMoneyFlow(BarSeries barSeries) {
        return UnaryOperation.unaryOperation(DirectionalMoneyFlowResult::getNegative, DirectionalMoneyFlow.directionalMoneyFlow(barSeries));
    }

    public static DirectionalMoneyFlow dmf(BarSeries barSeries) {
        return DirectionalMoneyFlow.directionalMoneyFlow(barSeries);
    }

    public static DirectionalMoneyFlow directionalMoneyFlow(BarSeries barSeries) {
        return (DirectionalMoneyFlow)CACHE.get((Object)new CacheKey(barSeries), key -> new DirectionalMoneyFlow(barSeries));
    }

    protected DirectionalMoneyFlow(BarSeries barSeries) {
        super(barSeries, 1);
        this.hlc3 = (Hlc3)Hlc3.hlc3(barSeries).caching();
        this.volume = Volume.volume(barSeries);
    }

    @Override
    protected DirectionalMoneyFlowResult calculate(long index) {
        DirectionalMoneyFlowResult.DirectionalMoneyFlowResultBuilder result = DirectionalMoneyFlowResult.builder().positive(this.numOfZero()).negative(this.numOfZero());
        if (index == 0L) {
            return result.build();
        }
        Num previousHlc3Value = (Num)this.hlc3.getValue(index - 1L);
        Num hlc3Value = (Num)this.hlc3.getValue(index);
        Num moneyFlow = hlc3Value.multiply((Num)this.volume.getValue(index));
        if (hlc3Value.isGreaterThan(previousHlc3Value)) {
            result.positive(moneyFlow);
        } else if (hlc3Value.isLessThan(previousHlc3Value)) {
            result.negative(moneyFlow);
        }
        return result.build();
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DirectionalMoneyFlow.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

