/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.series;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import trade.invision.num.DecimalNum;
import trade.invision.num.Num;
import trade.invision.num.NumFactory;

public class Series<T> {
    protected final int maximumLength;
    protected final NumFactory numFactory;
    protected final Num epsilon;
    protected final List<T> values;
    protected long startIndex;
    protected long endIndex;
    protected long addCallCount;

    public Series(int maximumLength) {
        this(null, maximumLength, null, null);
    }

    public Series(@Nullable Collection<T> initialValues, int maximumLength) {
        this(initialValues, maximumLength, null, null);
    }

    public Series(int maximumLength, @Nullable NumFactory numFactory) {
        this(null, maximumLength, numFactory, null);
    }

    public Series(@Nullable Collection<T> initialValues, int maximumLength, @Nullable NumFactory numFactory, @Nullable Num epsilon) {
        Preconditions.checkArgument((maximumLength > 0 ? 1 : 0) != 0, (Object)"'maximumLength' must be greater than zero!");
        this.maximumLength = maximumLength;
        this.numFactory = numFactory != null ? numFactory : DecimalNum.decimalNum64Factory();
        this.epsilon = epsilon != null ? epsilon : this.numFactory.zero();
        List<Object> list = this.values = initialValues != null ? new ArrayList<T>(initialValues) : new ArrayList(0);
        if (this.values.isEmpty()) {
            this.startIndex = -1L;
            this.endIndex = -1L;
        } else {
            if (this.values.size() > maximumLength) {
                this.values.subList(0, this.values.size() - maximumLength).clear();
            }
            this.startIndex = 0L;
            this.endIndex = this.values.size() - 1;
        }
    }

    public void replaceLast(T value) {
        this.add(value, true);
    }

    public void add(T value) {
        this.add(value, false);
    }

    public void add(T value, boolean replaceLast) {
        ++this.addCallCount;
        if (replaceLast && !this.values.isEmpty()) {
            this.values.set(this.values.size() - 1, value);
            return;
        }
        this.values.add(value);
        if (this.startIndex == -1L) {
            this.startIndex = 0L;
        }
        ++this.endIndex;
        if (this.values.size() > this.maximumLength) {
            this.values.removeFirst();
            ++this.startIndex;
        }
    }

    public T get(long index) {
        try {
            return this.values.get((int)Math.max(index - this.startIndex, 0L));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException(String.format("length=%d, startIndex=%d, endIndex=%d, index=%d", this.getLength(), this.startIndex, this.endIndex, index));
        }
    }

    public T getFirst() {
        return this.get(this.startIndex);
    }

    public T getLast() {
        return this.get(this.endIndex);
    }

    public long getLength() {
        return this.endIndex >= 0L ? this.endIndex - this.startIndex + 1L : 0L;
    }

    public boolean isEmpty() {
        return this.getLength() == 0L;
    }

    public List<T> listView() {
        return Collections.unmodifiableList(this.values);
    }

    public Num numOf(Number number) {
        return this.numFactory.of(number);
    }

    public Num numOf(BigDecimal bigDecimal) {
        return this.numFactory.of(bigDecimal);
    }

    public Num numOf(String string) {
        return this.numFactory.of(string);
    }

    public Num numOf(Num num) {
        return this.numFactory.of(num);
    }

    @Generated
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Generated
    public NumFactory getNumFactory() {
        return this.numFactory;
    }

    @Generated
    public Num getEpsilon() {
        return this.epsilon;
    }

    @Generated
    public long getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public long getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public long getAddCallCount() {
        return this.addCallCount;
    }
}

