/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.series.bar;

import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import trade.invision.num.Num;

public final class Bar {
    private final Instant start;
    private final Instant end;
    private final Num open;
    private final Num high;
    private final Num low;
    private final Num close;
    private final Num volume;
    private final Num tradeCount;

    public Bar(Instant start, Duration duration, Num tradePrice, Num tradeVolume) {
        this(start, duration, tradePrice, tradePrice, tradePrice, tradePrice, tradeVolume, tradePrice.factory().one());
    }

    public Bar(Instant start, Duration duration, Num open, Num high, Num low, Num close, Num volume, Num tradeCount) {
        this.start = start;
        this.end = start.plus(duration);
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
        this.tradeCount = tradeCount;
    }

    public Duration getDuration() {
        return Duration.between(this.start, this.end);
    }

    public Bar addPrice(Num price) {
        return this.addTrade(price, null);
    }

    public Bar addTrade(Num price, @Nullable Num volume) {
        return new Bar(this.start, this.end, this.open, this.high.maximum(price), this.low.minimum(price), price, volume == null ? this.volume : this.volume.add(volume), this.tradeCount.increment());
    }

    public Bar aggregate(Bar bar) {
        boolean thisStart = !this.start.isAfter(bar.start);
        boolean otherEnd = !bar.end.isBefore(this.end);
        return new Bar(thisStart ? this.start : bar.start, otherEnd ? bar.end : this.end, thisStart ? this.open : bar.open, this.high.maximum(bar.high), this.low.minimum(bar.low), otherEnd ? bar.close : this.close, this.volume.add(bar.volume), this.tradeCount.add(bar.tradeCount));
    }

    public boolean containsInstant(Instant instant) {
        return !instant.isBefore(this.start) && instant.isBefore(this.end);
    }

    public boolean overlaps(Bar bar) {
        return this.containsInstant(bar.start) || this.containsInstant(bar.end);
    }

    public boolean isBullish() {
        return this.close.isGreaterThan(this.open);
    }

    public boolean isBearish() {
        return this.close.isLessThan(this.open);
    }

    @Generated
    public static BarBuilder builder() {
        return new BarBuilder();
    }

    @Generated
    public BarBuilder toBuilder() {
        return new BarBuilder().start(this.start).end(this.end).open(this.open).high(this.high).low(this.low).close(this.close).volume(this.volume).tradeCount(this.tradeCount);
    }

    @Generated
    public Instant getStart() {
        return this.start;
    }

    @Generated
    public Instant getEnd() {
        return this.end;
    }

    @Generated
    public Num getOpen() {
        return this.open;
    }

    @Generated
    public Num getHigh() {
        return this.high;
    }

    @Generated
    public Num getLow() {
        return this.low;
    }

    @Generated
    public Num getClose() {
        return this.close;
    }

    @Generated
    public Num getVolume() {
        return this.volume;
    }

    @Generated
    public Num getTradeCount() {
        return this.tradeCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bar)) {
            return false;
        }
        Bar other = (Bar)o;
        Instant this$start = this.getStart();
        Instant other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Instant this$end = this.getEnd();
        Instant other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Num this$open = this.getOpen();
        Num other$open = other.getOpen();
        if (this$open == null ? other$open != null : !this$open.equals(other$open)) {
            return false;
        }
        Num this$high = this.getHigh();
        Num other$high = other.getHigh();
        if (this$high == null ? other$high != null : !this$high.equals(other$high)) {
            return false;
        }
        Num this$low = this.getLow();
        Num other$low = other.getLow();
        if (this$low == null ? other$low != null : !this$low.equals(other$low)) {
            return false;
        }
        Num this$close = this.getClose();
        Num other$close = other.getClose();
        if (this$close == null ? other$close != null : !this$close.equals(other$close)) {
            return false;
        }
        Num this$volume = this.getVolume();
        Num other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        Num this$tradeCount = this.getTradeCount();
        Num other$tradeCount = other.getTradeCount();
        return !(this$tradeCount == null ? other$tradeCount != null : !this$tradeCount.equals(other$tradeCount));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Instant $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Num $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : $open.hashCode());
        Num $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : $high.hashCode());
        Num $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : $low.hashCode());
        Num $close = this.getClose();
        result = result * 59 + ($close == null ? 43 : $close.hashCode());
        Num $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        Num $tradeCount = this.getTradeCount();
        result = result * 59 + ($tradeCount == null ? 43 : $tradeCount.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bar(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", open=" + String.valueOf(this.getOpen()) + ", high=" + String.valueOf(this.getHigh()) + ", low=" + String.valueOf(this.getLow()) + ", close=" + String.valueOf(this.getClose()) + ", volume=" + String.valueOf(this.getVolume()) + ", tradeCount=" + String.valueOf(this.getTradeCount()) + ")";
    }

    @Generated
    public Bar(Instant start, Instant end, Num open, Num high, Num low, Num close, Num volume, Num tradeCount) {
        this.start = start;
        this.end = end;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
        this.tradeCount = tradeCount;
    }

    @Generated
    public static class BarBuilder {
        @Generated
        private Instant start;
        @Generated
        private Instant end;
        @Generated
        private Num open;
        @Generated
        private Num high;
        @Generated
        private Num low;
        @Generated
        private Num close;
        @Generated
        private Num volume;
        @Generated
        private Num tradeCount;

        @Generated
        BarBuilder() {
        }

        @Generated
        public BarBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        @Generated
        public BarBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        @Generated
        public BarBuilder open(Num open) {
            this.open = open;
            return this;
        }

        @Generated
        public BarBuilder high(Num high) {
            this.high = high;
            return this;
        }

        @Generated
        public BarBuilder low(Num low) {
            this.low = low;
            return this;
        }

        @Generated
        public BarBuilder close(Num close) {
            this.close = close;
            return this;
        }

        @Generated
        public BarBuilder volume(Num volume) {
            this.volume = volume;
            return this;
        }

        @Generated
        public BarBuilder tradeCount(Num tradeCount) {
            this.tradeCount = tradeCount;
            return this;
        }

        @Generated
        public Bar build() {
            return new Bar(this.start, this.end, this.open, this.high, this.low, this.close, this.volume, this.tradeCount);
        }

        @Generated
        public String toString() {
            return "Bar.BarBuilder(start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", open=" + String.valueOf(this.open) + ", high=" + String.valueOf(this.high) + ", low=" + String.valueOf(this.low) + ", close=" + String.valueOf(this.close) + ", volume=" + String.valueOf(this.volume) + ", tradeCount=" + String.valueOf(this.tradeCount) + ")";
        }
    }
}

