/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Museum/Publisher contacts.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Contacts.Builder.class)
public abstract class Contacts implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Contacts.Builder();
    }

    /**
     * Phone number. Typical for museum.
     */
    @Nullable
    @JsonProperty("phone_number")
    public abstract String phone();

    /**
     * Website link. Typical for museum and publisher.
     */
    @Nullable
    public abstract String website();

    /**
     * Country code, ISO 3166-1 alpha-2. Typical for museum.
     */
    @Nullable
    public abstract String country();

    /**
     * City name. Typical for museum.
     */
    @Nullable
    public abstract String city();

    /**
     * Address. Typical for museum.
     */
    @Nullable
    public abstract String address();

    /**
     * Postal code. Typical for museum.
     */
    @Nullable
    public abstract String postcode();

    /**
     * Administrative subdivision. Typical for museum.
     */
    @Nullable
    public abstract String state();

    /**
     * URL to Twitter account. Typical for publisher.
     */
    @Nullable
    public abstract String twitter();

    /**
     * URL to Facebook account. Typical for publisher.
     */
    @Nullable
    public abstract String facebook();

    /**
     * URL to Google+ account. Typical for publisher.
     */
    @Nullable
    public abstract String googleplus();

    /**
     * URL to Instagram account. Typical for publisher.
     */
    @Nullable
    public abstract String instagram();

    /**
     * URL to Youtube account. Typical for publisher.
     */
    @Nullable
    public abstract String youtube();

    /**
     * URL to VK account. Typical for publisher.
     */
    @Nullable
    public abstract String vk();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        @JsonProperty("phone_number")
        public abstract Builder phone(String phone);
        public abstract Builder website(String website);
        public abstract Builder country(String country);
        public abstract Builder city(String city);
        public abstract Builder address(String address);
        public abstract Builder postcode(String postcode);
        public abstract Builder state(String state);
        public abstract Builder twitter(String twitter);
        public abstract Builder facebook(String facebook);
        public abstract Builder googleplus(String googleplus);
        public abstract Builder instagram(String instagram);
        public abstract Builder youtube(String youtube);
        public abstract Builder vk(String vk);

        public abstract Contacts build();
    }
}