/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Mapping details.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Map.Builder.class)
public abstract class Map implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Map.Builder();
    }

    /**
     * Surface bounds for a MTGObject. E.g., bounds for a tour route. The maximum extent of the
     * rendered map area. Bounds must define an area covered by all zoom levels. The bounds are
     * represented as WGS:84 in the OpenLayers Bounds format - left, bottom, right, top.
     * Typical for museum, tour.
     * <p>E.g.., "36.0123075,122.0978486,36.0176986,122.0911837"</p>
     */
    @NonNull
    public abstract String bounds();

    /**
     * Route in KML format. This route is for display on map purposes only. Typical for tour.
     */
    @Nullable
    public abstract String route();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder bounds(String bounds);
        public abstract Builder route(String route);

        public abstract Map build();
    }
}