/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import auto.parcel.AutoParcel;
import travel.izi.api.service.MtgObjectService;

/**
 * Response object for endpoint {@link MtgObjectService#getProductId(String)}.
 */
@AutoParcel
public abstract class ProductIdResponse implements Parcelable {

    @JsonCreator
    public static ProductIdResponse create(@JsonProperty("product_id") String productId) {
        return new AutoParcel_ProductIdResponse(productId);
    }

    /**
     * This parameter must be used as "product ID" at an app market.
     */
    @NonNull
    public abstract String productId();
}