/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.Date;

import auto.parcel.AutoParcel;

/**
 * The review.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Review.Builder.class)
public abstract class Review implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Review.Builder();
    }

    /**
     * Unique identifier of rating/review across system.
     */
    @NonNull
    public abstract Long id();

    /**
     * UTC time of Rating/Review submit. Format is according to ISO-8601 "YYYY-MM-DDThh:mm:ssZ".
     */
    @NonNull
    public abstract Date date();

    /**
     * Rating of the content [0..10].
     */
    @Nullable
    public abstract Integer rating();

    /**
     * Review on the content (limitation: 500).
     */
    @Nullable
    public abstract String review();

    /**
     * Author of review (limitation: 128).
     */
    @Nullable
    public abstract String reviewerName();

    /**
     * Language of reviewed content.
     */
    @NonNull
    @JsonProperty("lang")
    public abstract String language();

    /**
     * Hash of content passed at POST (MTGObject hash returned by common API).
     */
    @NonNull
    public abstract String hash();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder id(Long id);
        public abstract Builder date(Date date);
        public abstract Builder rating(Integer rating);
        public abstract Builder review(String review);
        public abstract Builder reviewerName(String reviewerName);
        @JsonProperty("lang")
        public abstract Builder language(String language);
        public abstract Builder hash(String hash);

        public abstract Review build();
    }
}