/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * The media types.
 */
public enum MediaType {

    /**
     * Media of museum, exhibit, tour, tourist_attraction, story_navigation and collection.
     */
    Story("story"),

    /**
     * Image of the museum map.
     */
    Map("map"),

    /**
     * Logo image of the publisher.
     */
    BrandLogo("brand_logo"),

    /**
     * Cover image of the publisher.
     */
    BrandCover("brand_cover"),

    /**
     * Image of the city.
     */
    City("city"),

    /**
     * Logo image of the sponsor.
     */
    SponsorLogo("sponsor_logo"),

    /**
     * Image of the featured content.
     */
    Featured("featured");

    private final String value;

    private MediaType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, MediaType> STRING_MAPPING = new HashMap<>();

    static {
        for (MediaType via : MediaType.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    @SuppressWarnings("unused")
    @JsonCreator
    public static MediaType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}