/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * Playback's types. Describes how to play data inside MTGObject and its children.
 */
public enum PlaybackType {

    /**
     * Consumer must follow a sequence of children MTGObjects one by one. Order is defined
     * by "order" parameter inside a child MTGObject.
     */
    Sequential("sequential"),

    /**
     * The same, as {@link #Sequential}, but order is not important.
     */
    Random("random");

    private final String value;

    private PlaybackType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, PlaybackType> STRING_MAPPING = new HashMap<>();

    static {
        for (PlaybackType via : PlaybackType.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    @SuppressWarnings("unused")
    @JsonCreator
    public static PlaybackType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}