/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * This object contains a list of links to these packages:
 * <ol>
 * <li>Archives with MTGObject and its children data: JSON objects, images and audio files.
 * <li>Archive with map tiles for offline mapping.
 * <li>Archive with video files.
 * </ol>
 * <p>The `download` object is included into MTGObject only if at least one package exists.</p>
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Download.Builder.class)
public abstract class Download implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Download.Builder();
    }

    /**
     * Package of download.
     */
    @AutoParcel
    @JsonDeserialize(builder = AutoParcel_Download_Package.Builder.class)
    public abstract static class Package implements Parcelable {

        public static Builder builder() {
            return new AutoParcel_Download_Package.Builder();
        }

        /**
         * Direct link to download a package.
         */
        @NonNull
        public abstract String url();

        /**
         * File size (in bytes).
         */
        @NonNull
        public abstract Integer size();

        /**
         * MD5 hash from file. Actually this is ETag property for checking if content changed.
         */
        @NonNull
        public abstract String md5();

        /**
         * Date of the package generation.
         */
        @Nullable
        public abstract String updatedAt();

        @AutoParcel.Builder
        @JsonPOJOBuilder(withPrefix = "")
        public abstract static class Builder {
            public abstract Builder url(String url);
            public abstract Builder size(Integer size);
            public abstract Builder md5(String md5);
            public abstract Builder updatedAt(String updatedAt);

            public abstract Package build();
        }
    }

    /**
     * Package with off-line map in mbtiles format for current MTGObject.
     * <p>NOTE: Will be deprecated in 2016.</p>
     */
    @Nullable
    @Deprecated
    @JsonProperty("map-mbtiles")
    public abstract Package map();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        @Deprecated
        @JsonProperty("map-mbtiles")
        public abstract Builder map(Package map);

        public abstract Download build();
    }
}