/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Geo and indoor positioning.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Location.Builder.class)
public abstract class Location implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Location.Builder();
    }

    /**
     * Object latitude.
     */
    @Nullable
    public abstract Double latitude();

    /**
     * Object longitude.
     */
    @Nullable
    public abstract Double longitude();

    /**
     * Object altitude. This parameter has zero value for now and reserved
     * for future use and geocoding consistency.
     */
    @Nullable
    public abstract Double altitude();

    /**
     * Museum`s exhibit number.
     */
    @Nullable
    public abstract String number();

    /**
     * Public IP address of object’s WiFi router. PLEASE NOTE: The value
     * is not validated in izi.CMS and can not follow IPv4/IPv6 notation.
     */
    @Nullable
    public abstract String ip();

    /**
     * UUID of city. Typical for tour, museum, tourist_attraction.
     */
    @Nullable
    public abstract String cityUuid();

    /**
     * Country code, ISO 3166-1 alpha-2. Typical for tour, museum,
     * tourist_attraction, city.
     */
    @Nullable
    public abstract String countryCode();

    /**
     * UUID of country. Typical for tour, museum,
     * tourist_attraction, city.
     */
    @Nullable
    public abstract String countryUuid();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder latitude(Double latitude);
        public abstract Builder longitude(Double longitude);
        public abstract Builder altitude(Double altitude);
        public abstract Builder number(String number);
        public abstract Builder ip(String ip);
        public abstract Builder cityUuid(String cityUuid);
        public abstract Builder countryCode(String countryCode);
        public abstract Builder countryUuid(String countryUuid);

        public abstract Location build();
    }
}