/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Commercial content purchase details.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Purchase.Builder.class)
public abstract class Purchase implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Purchase.Builder();
    }

    /**
     * Content's price (Decimal(6,2)).
     */
    @NonNull
    public abstract Float price();

    /**
     * Currency.
     *
     * @see <a href="http://en.wikipedia.org/wiki/ISO_4217">ISO 4217</a>
     */
    @NonNull
    public abstract String currency();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder price(Float price);
        public abstract Builder currency(String currency);

        public abstract Purchase build();
    }
}