/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import com.google.gson.annotations.SerializedName;
import travel.izi.api.model.IZITravelEntity;

/**
 * Museum/Publisher contacts.
 */
@SuppressWarnings("unused")
public class Contacts implements IZITravelEntity {
    private static final long serialVersionUID = 9000346967520879862L;

    /**
     * Phone number. Typical for museum.
     */
    @SerializedName("phone_number")
    public String phone;

    /**
     * Website link. Typical for museum and publisher.
     */
    public String website;

    /**
     * Country code, ISO 3166-1 alpha-2. Typical for museum.
     */
    public String country;

    /**
     * City name. Typical for museum.
     */
    public String city;

    /**
     * Address. Typical for museum.
     */
    public String address;

    /**
     * Postal code. Typical for museum.
     */
    public String postcode;

    /**
     * Administrative subdivision. Typical for museum.
     */
    public String state;

    /**
     * URL to Twitter account. Typical for publisher.
     */
    private String twitter;

    /**
     * URL to Facebook account. Typical for publisher.
     */
    private String facebook;

    /**
     * URL to Google+ account. Typical for publisher.
     */
    private String googleplus;

    /**
     * URL to Instagram account. Typical for publisher.
     */
    private String instagram;

    /**
     * URL to Youtube account. Typical for publisher.
     */
    private String youtube;

    /**
     * URL to VK account. Typical for publisher.
     */
    private String vk;

}