/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import travel.izi.api.model.IZITravelEntity;

/**
 * Geo and indoor positioning.
 */
@SuppressWarnings("unused")
public class Location implements IZITravelEntity {
    private static final long serialVersionUID = -9075388054707194916L;

    /**
     * Object latitude.
     */
    public double latitude;

    /**
     * Object longitude.
     */
    public double longitude;

    /**
     * Object altitude. This parameter has zero value for now and reserved
     * for future use and geocoding consistency.
     */
    public double altitude;

    /**
     * Museum`s exhibit number.
     */
    public String number;

    /**
     * Public IP address of object’s WiFi router. PLEASE NOTE: The value
     * is not validated in izi.CMS and can not follow IPv4/IPv6 notation.
     */
    public String ip;

    /**
     * UUID of city. Typical for tour, museum, tourist_attraction.
     */
    public String cityUuid;

    /**
     * Country code, ISO 3166-1 alpha-2. Typical for tour, museum,
     * tourist_attraction, city.
     */
    public String countryCode;

    /**
     * UUID of country. Typical for tour, museum,
     * tourist_attraction, city.
     */
    public String countryUuid;

}