/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import travel.izi.api.model.IZITravelEnumeration;

import java.util.HashMap;
import java.util.Map;

/**
 * Trigger zone types.
 */
public enum TriggerZoneType implements IZITravelEnumeration {

    /**
     * Polygon shaped trigger zone.
     */
    Polygon("polygon"),

    /**
     * Circle shaped trigger zone.
     */
    Circle("circle");

    private final String value;

    @SuppressWarnings("UnnecessaryEnumModifier")
    private TriggerZoneType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, TriggerZoneType> STRING_MAPPING = new HashMap<String, TriggerZoneType>();

    static {
        for (TriggerZoneType via : TriggerZoneType.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    public static TriggerZoneType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}