/*
 * Decompiled with CFR 0.152.
 */
package travel.izi.api;

import com.google.gson.GsonBuilder;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.util.concurrent.TimeUnit;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import travel.izi.api.IZITravelError;
import travel.izi.api.service.CityService;
import travel.izi.api.service.CountryService;
import travel.izi.api.service.FeaturedService;
import travel.izi.api.service.LanguageService;
import travel.izi.api.service.MtgObjectService;
import travel.izi.api.service.PublisherService;
import travel.izi.api.service.ReviewService;
import travel.izi.api.service.SearchService;
import travel.izi.api.util.GsonHelper;
import travel.izi.api.util.MediaHelper;

public class IZITravel {
    public static final Server SERVER_PRODUCTION = new Server("http://api.izi.travel", "http://media.izi.travel");
    public static final Server SERVER_STAGING = new Server("http://api.stage.izi.travel", "http://media.stage.izi.travel");
    public static final Server SERVER_DEVELOPMENT = new Server("http://api.dev.izi.travel", "http://media.dev.izi.travel");
    public static final String API_VERSION = "1.2.4";
    private static final int CONNECT_TIMEOUT_MILLIS = 15000;
    private static final int READ_TIMEOUT_MILLIS = 20000;
    private final String mApiKey;
    private final String mApiVersion;
    private final String mApiPassword;
    private final String mUserAgent;
    private final Server mServer;
    private final Cache mCache;
    private final boolean mLoggingEnabled;
    private final RestAdapter mRestAdapter;

    private IZITravel(String apiKey, String apiVersion, String apiPassword, String userAgent, Server server, Cache cache, boolean loggingEnabled) {
        this.mApiKey = apiKey;
        this.mApiVersion = apiVersion;
        this.mApiPassword = apiPassword;
        this.mUserAgent = userAgent;
        this.mServer = server;
        this.mCache = cache;
        this.mLoggingEnabled = loggingEnabled;
        this.mRestAdapter = this.buildRestAdapter();
    }

    protected RestAdapter buildRestAdapter() {
        RestAdapter.Builder builder = new RestAdapter.Builder().setEndpoint(this.mServer.getApiUrl()).setClient((Client)new OkClient(this.getOkHttpClient())).setConverter((Converter)new GsonConverter(this.getGsonBuilder().create())).setErrorHandler(this.getErrorHandler()).setRequestInterceptor(this.getRequestInterceptor());
        if (this.mLoggingEnabled) {
            builder.setLogLevel(RestAdapter.LogLevel.FULL);
        }
        return builder.build();
    }

    protected OkHttpClient getOkHttpClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(15000L, TimeUnit.MILLISECONDS);
        client.setReadTimeout(20000L, TimeUnit.MILLISECONDS);
        if (this.mCache != null) {
            client.setCache(this.mCache);
        }
        return client;
    }

    protected GsonBuilder getGsonBuilder() {
        return GsonHelper.getGsonBuilder();
    }

    protected ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            public Throwable handleError(RetrofitError error) {
                return IZITravelError.from(error);
            }
        };
    }

    protected RequestInterceptor getRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Accept", String.format("application/izi-api-v%s+json", IZITravel.this.mApiVersion));
                request.addHeader("X-IZI-API-KEY", IZITravel.this.mApiKey);
                if (IZITravel.this.mApiPassword != null) {
                    request.addHeader("X-IZI-API-PASSWORD", IZITravel.this.mApiPassword);
                }
                if (IZITravel.this.mUserAgent != null) {
                    request.addHeader("User-Agent", IZITravel.this.mUserAgent);
                }
                request.addHeader("Cache-Control", "max-stale=3600");
            }
        };
    }

    public CityService cityService() {
        return (CityService)this.mRestAdapter.create(CityService.class);
    }

    public CountryService countryService() {
        return (CountryService)this.mRestAdapter.create(CountryService.class);
    }

    public FeaturedService featuredService() {
        return (FeaturedService)this.mRestAdapter.create(FeaturedService.class);
    }

    public LanguageService languageService() {
        return (LanguageService)this.mRestAdapter.create(LanguageService.class);
    }

    public MtgObjectService mtgObjectService() {
        return (MtgObjectService)this.mRestAdapter.create(MtgObjectService.class);
    }

    public PublisherService publisherService() {
        return (PublisherService)this.mRestAdapter.create(PublisherService.class);
    }

    public ReviewService reviewService() {
        return (ReviewService)this.mRestAdapter.create(ReviewService.class);
    }

    public SearchService searchService() {
        return (SearchService)this.mRestAdapter.create(SearchService.class);
    }

    public MediaHelper mediaHelper() {
        return new MediaHelper(this.mServer.getMediaUrl());
    }

    public static IZITravel withApiKey(String apiKey) {
        return new Builder().apiKey(apiKey).build();
    }

    public static class Server {
        private final String apiUrl;
        private final String mediaUrl;

        public Server(String apiUrl, String mediaUrl) {
            this.apiUrl = apiUrl;
            this.mediaUrl = mediaUrl;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }

        public String getMediaUrl() {
            return this.mediaUrl;
        }
    }

    public static class Builder {
        private String mApiKey;
        private String mApiVersion;
        private String mApiPassword;
        private String mUserAgent;
        private Server mServer;
        private Cache mCache;
        private boolean mLoggingEnabled;

        public Builder apiKey(String apiKey) {
            if (apiKey == null) {
                throw new IllegalArgumentException("ApiKey must not be null.");
            }
            this.mApiKey = apiKey;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            if (apiVersion == null) {
                throw new IllegalArgumentException("ApiVersion must not be null.");
            }
            this.mApiVersion = apiVersion;
            return this;
        }

        public Builder apiPassword(String apiPassword) {
            this.mApiPassword = apiPassword;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public Builder server(Server server) {
            if (server == null) {
                throw new IllegalArgumentException("Server must not be null.");
            }
            this.mServer = server;
            return this;
        }

        public Builder cache(File cacheDirectory, int cacheSize) {
            this.mCache = new Cache(cacheDirectory, (long)cacheSize);
            return this;
        }

        public Builder loggingEnabled(boolean enabled) {
            this.mLoggingEnabled = enabled;
            return this;
        }

        public IZITravel build() {
            if (this.mApiKey == null) {
                throw new IllegalArgumentException("API key is not specified");
            }
            if (this.mApiVersion == null) {
                this.mApiVersion = IZITravel.API_VERSION;
            }
            if (this.mServer == null) {
                this.mServer = SERVER_PRODUCTION;
            }
            return new IZITravel(this.mApiKey, this.mApiVersion, this.mApiPassword, this.mUserAgent, this.mServer, this.mCache, this.mLoggingEnabled);
        }
    }
}

