/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import travel.izi.api.model.IZITravelEntity;
import travel.izi.api.model.enumeration.Category;
import travel.izi.api.model.enumeration.MtgObjectType;
import travel.izi.api.model.enumeration.Placement;
import travel.izi.api.model.enumeration.Status;

/**
 * MTG Object (Mobile Traveller Guide Object) is a core content object. MTGObject, depending on its "type" property,
 * represents any MTG Content object (museum, tour, navigation story, tourist attraction, publisher, country or city).
 * MTGObject can be requested in full and compact formats.
 */
@SuppressWarnings("unused")
public abstract class MtgObject implements IZITravelEntity {

    /**
     * Universally Unique Identifier of MtgObject.
     */
    public String uuid;

    /**
     * Type of MtgObject.
     */
    public MtgObjectType type;

    /**
     * Category of tour.
     */
    public Category category;

    /**
     * Content publication status.
     */
    public Status status;

    /**
     * Publisher.
     */
    public CompactMtgObject publisher;

    /**
     * Content provider.
     */
    public ContentProvider contentProvider;

    /**
     * Array of all available languages of MtgObject content (ISO 639-1).
     * <p>EXCEPTION: For countries and cities is an array of languages
     * for which there are MTGObject in this locality.</p>
     */
    public String[] languages;

    /**
     * Location of MtgObject.
     */
    public Location location;

    /**
     * Compact version of country.
     */
    public CompactMtgObject country;

    /**
     * Compact version of city.
     */
    public CompactMtgObject city;

    /**
     * Array of trigger zones.
     */
    public TriggerZone[] triggerZones;

    /**
     * Object with mapping details.
     */
    public Map map;

    /**
     * Tour placement.
     */
    public Placement placement;

    /**
     * Distance of tour (in meters).
     */
    public int distance;

    /**
     * Total duration of tour (in seconds).
     * <p>NOTE: Value is calculated as: distance / category speed.</p>
     */
    public int duration;

    /**
     * Object with product purchasing details.
     */
    public Purchase purchase;

    /**
     * Available translations of the locality name (typical for city and country).
     */
    public Translation[] translations;

    /**
     * Country code (ISO 3166-1) (typical for country).
     */
    public String countryCode;

    /**
     * The average of ratings/reviews. The section will be returned if the average was calculated.
     */
    public ReviewsResponse.Estimation reviews;

    /**
     * Tourist attraction map visibility. Can be: false – object shall be displayed on a map;
     * true – object is hidden from the user.
     */
    public boolean hidden;

    /**
     * Typical for city. Defines if the city should be displayed on izi.TRAVEL site main page.
     */
    public boolean visible;

    /**
     * SHA1 hash from "uuid + last updated" string.
     */
    public String hash;

}