/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import com.google.gson.annotations.SerializedName;
import travel.izi.api.model.IZITravelEntity;

import java.util.Date;

/**
 * The review.
 */
@SuppressWarnings("unused")
public class Review implements IZITravelEntity {
    private static final long serialVersionUID = 2736455010534732511L;

    /**
     * Unique identifier of rating/review across system.
     */
    public Long id;

    /**
     * UTC time of Rating/Review submit. Format is according to ISO-8601 "YYYY-MM-DDThh:mm:ssZ".
     */
    public Date date;

    /**
     * Rating of the content [0..10].
     */
    public Integer rating;

    /**
     * Review on the content (limitation: 500).
     */
    public String review;

    /**
     * Author of review (limitation: 128).
     */
    public String reviewerName;

    /**
     * Language of reviewed content.
     */
    @SerializedName("lang")
    public String language;

    /**
     * Hash of content passed at POST (MTGObject hash returned by common API).
     */
    public String hash;

    public Review() {
    }

    public Review(String language, String hash, Integer rating) {
        this(language, hash, rating, null, null);
    }

    public Review(String language, String hash, String review, String reviewerName) {
        this(language, hash, null, review, reviewerName);
    }

    public Review(String language, String hash, Integer rating, String review, String reviewerName) {
        this.language = language;
        this.hash = hash;
        this.rating = rating;
        this.review = review;
        this.reviewerName = reviewerName;
    }

}