/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * <p>All IZITravel-defined enumerations which are used both in request responses
 * as well as building remote requests.</p>
 *
 * <p>Serialization of these enumerations is handled by overriding the
 * <code>toString()</code> method. Additionally, all enumerations must implement
 * the {@link travel.izi.api.model.IZITravelEnumeration} interface in order to
 * be properly serialized.</p>
 *
 * <p>Deserialization of an enumerable value requires registration with the
 * GSON builder in the
 * {@link travel.izi.api.util.GsonHelper#getGsonBuilder()} method.
 * An appropriate method of deserialization should be handled by a static
 * method defined within the type, by convention,
 * <code>fromString(String)</code>.</p>
 */
package travel.izi.api.model.enumeration;