/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.util;

import com.google.gson.*;
import travel.izi.api.model.enumeration.*;

import java.lang.reflect.Type;

public class GsonHelper {

    private GsonHelper() {
    }

    /**
     * Create a {@link com.google.gson.GsonBuilder} and register all of the custom types needed in order to properly
     * deserialize complex IZITravel-specific type.
     *
     * @return Assembled GSON builder instance.
     */
    public static GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();

        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

        //enum types
        builder.registerTypeAdapter(Category.class, new JsonDeserializer<Category>() {
            @Override
            public Category deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return Category.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(MediaType.class, new JsonDeserializer<MediaType>() {
            @Override
            public MediaType deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return MediaType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(MtgObjectType.class, new JsonDeserializer<MtgObjectType>() {
            @Override
            public MtgObjectType deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return MtgObjectType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(Placement.class, new JsonDeserializer<Placement>() {
            @Override
            public Placement deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return Placement.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(PlaybackType.class, new JsonDeserializer<PlaybackType>() {
            @Override
            public PlaybackType deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return PlaybackType.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(Status.class, new JsonDeserializer<Status>() {
            @Override
            public Status deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return Status.fromValue(json.getAsString());
            }
        });
        builder.registerTypeAdapter(TriggerZoneType.class, new JsonDeserializer<TriggerZoneType>() {
            @Override
            public TriggerZoneType deserialize(JsonElement json, Type typeOfT,
                    JsonDeserializationContext context) throws JsonParseException {
                return TriggerZoneType.fromValue(json.getAsString());
            }
        });

        return builder;
    }

}