/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import com.google.gson.annotations.SerializedName;

/**
 * The compact version of {@link MtgObject}. Used to display a list of items.
 */
@SuppressWarnings("unused")
public class CompactMtgObject extends MtgObject {
    private static final long serialVersionUID = -6765762325500029435L;

    /**
     * Language (ISO 639-1) of object's content.
     */
    public String language;

    /**
     * Title.
     */
    public String title;

    /**
     * Shortened description.
     */
    public String summary;

    /**
     * Full description. Only for objects from "children" section.
     */
    @SerializedName("desc")
    public String description;

    /**
     * Array of images data.
     * <p>NOTE: Contains only one object (first image).</p>
     */
    public Media[] images;

    /**
     * Quiz data. Only for objects from "children" section.
     */
    public Quiz quiz;

    /**
     * Route in KML format (typical for tour). This route is for display on map purposes only.
     */
    public String route;

    /**
     * Number of children.
     */
    public int childrenCount;

}