/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import travel.izi.api.model.IZITravelEnumeration;

import java.util.HashMap;
import java.util.Map;

/**
 * MtgObject's types.
 */
public enum MtgObjectType implements IZITravelEnumeration {

    /**
     * Museum.
     */
    Museum("museum"),

    /**
     * Exhibit inside a museum.
     */
    Exhibit("exhibit"),

    /**
     * Introduction story (typical for museum).
     */
    StoryIntroduction("story_introduction"),

    /**
     * Navigation story. Mostly used inside tours or museum's collections.
     */
    StoryNavigation("story_navigation"),

    /**
     * Everything representing sequential or random list of MtgObjects to visit:
     * exhibition inside a museum, city tour, a list of stories about a country.
     */
    Tour("tour"),

    /**
     * Mostly outdoor tourist attraction.
     */
    TouristAttraction("tourist_attraction"),

    /**
     * Museum sets of exhibits.
     */
    Collection("collection"),

    /**
     * The publisher.
     */
    Publisher("publisher"),

    /**
     * The country.
     */
    Country("country"),

    /**
     * The city.
     */
    City("city");

    private final String value;

    @SuppressWarnings("UnnecessaryEnumModifier")
    private MtgObjectType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, MtgObjectType> STRING_MAPPING = new HashMap<String, MtgObjectType>();

    static {
        for (MtgObjectType via : MtgObjectType.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    public static MtgObjectType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}