package travel.izi.api.service;

import retrofit.http.GET;

import java.util.List;

/**
 * Endpoints for Languages.
 */
@SuppressWarnings("unused")
public interface LanguageService {

    /**
     * Returns the languages list of existent content in izi.TRAVEL Directory. The list can be used for retrieving
     * any reachable content using '&amp;languages=' parameter in API requests.
     * <p>NOTE: The list of languages has predefined order.</p>
     *
     * @return An array of languages where content exists in izi.TRAVEL Directory.
     */
    @GET("/languages/used")
    List<String> getUsedLanguages();

    /**
     * Returns all available languages in izi.TRAVEL Directory for creation and publishing content,
     * however, only part of these languages is used, to get the list of languages where content exists,
     * you shall use {@link #getUsedLanguages()}.
     * <p>NOTE: The list of languages has predefined order.</p>
     *
     * @return An array of languages available in izi.TRAVEL Directory to publish content.
     */
    @GET("/languages/supported")
    List<String> getSupportedLanguages();

}