/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Copyright information.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_ContentProvider.Builder.class)
public abstract class ContentProvider implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_ContentProvider.Builder();
    }

    /**
     * Universally Unique Identifier of content provider.
     */
    @NonNull
    public abstract String uuid();

    /**
     * Not localized Content Provider’s name.
     */
    @NonNull
    public abstract String name();

    /**
     * Content provider copyright information. E.g., “© 2015 Art Museum”.
     */
    @Nullable
    public abstract String copyright();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder uuid(String uuid);
        public abstract Builder name(String name);
        public abstract Builder copyright(String copyright);

        public abstract ContentProvider build();
    }
}