/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.List;

import auto.parcel.AutoParcel;
import travel.izi.api.model.enumeration.Category;
import travel.izi.api.model.enumeration.MtgObjectType;

/**
 * Promoted or most popular published tours and museums.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_FeaturedObject.Builder.class)
public abstract class FeaturedObject implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_FeaturedObject.Builder();
    }

    /**
     * Universally Unique Identifier of the object.
     */
    @NonNull
    public abstract String uuid();

    /**
     * Object type (museum or tour).
     */
    @NonNull
    public abstract MtgObjectType type();

    /**
     * Category (typical for tour).
     */
    @Nullable
    public abstract Category category();

    /**
     * Title (name) defined by a featured content publisher.
     */
    @NonNull
    public abstract String title();

    /**
     * Optional sub-title (additional info) defined by a featured content publisher.
     * Examples: ‘BUS TOUR’, 'MUSEUM’, 'WALKING TOUR’.
     */
    @Nullable
    public abstract String subTitle();

    /**
     * A position of object in returned set (the order to show on a dashboard). Values: [1..10]
     */
    @NonNull
    public abstract Integer position();

    /**
     * Images of the content.
     * <p>NOTE: Contains only one object (first image).</p>
     */
    @NonNull
    public abstract List<Media> images();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder uuid(String uuid);
        public abstract Builder type(MtgObjectType type);
        public abstract Builder category(Category category);
        public abstract Builder title(String title);
        public abstract Builder subTitle(String subTitle);
        public abstract Builder position(Integer position);
        public abstract Builder images(List<Media> images);

        public abstract FeaturedObject build();
    }
}