/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;
import travel.izi.api.model.enumeration.MediaType;

/**
 * The media file details.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Media.Builder.class)
public abstract class Media implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Media.Builder();
    }

    /**
     * Universally Unique Identifier of media file.
     */
    @NonNull
    public abstract String uuid();

    /**
     * Type of media.
     */
    @NonNull
    public abstract MediaType type();

    /**
     * Defines in what order to show\play media. F.e., picture with order=1 is the first(default)
     * image to display.
     */
    @NonNull
    public abstract Integer order();

    /**
     * Duration of media file in seconds. Typical for audio, video.
     */
    @Nullable
    public abstract Integer duration();

    /**
     * Direct URL to media when a parameter media_links set to true.
     */
    @Nullable
    public abstract String url();

    /**
     * Title of media. Typical for {@link MediaType#Map} and {@link MediaType#Story} images.
     */
    @Nullable
    public abstract String title();

    /**
     * ETag hash for checking if file changed ({@link MediaType#BrandCover} and {@link
     * MediaType#City} has no hash).
     */
    @Nullable
    public abstract String hash();

    /**
     * Media size in bytes ({@link MediaType#BrandCover} and {@link MediaType#City} has no size).
     * In case of images with type {@link MediaType#Story}, the size of 800x600 image version is
     * used.
     */
    @Nullable
    public abstract Long size();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder uuid(String uuid);
        public abstract Builder type(MediaType type);
        public abstract Builder order(Integer order);
        public abstract Builder duration(Integer duration);
        public abstract Builder url(String url);
        public abstract Builder title(String title);
        public abstract Builder hash(String hash);
        public abstract Builder size(Long size);

        public abstract Media build();
    }
}