/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.List;

import auto.parcel.AutoParcel;
import travel.izi.api.model.enumeration.PlaybackType;

/**
 * MTGObjects playback algorithm settings.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Playback.Builder.class)
public abstract class Playback implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Playback.Builder();
    }

    /**
     * Describes how to play data inside MTGObject and its children.
     */
    @NonNull
    public abstract PlaybackType type();

    /**
     * List of UUIDs. Defines playback order of children MTGObjects. If set, a mobile application
     * can use this data for making decisions which story to play. The first array element is
     * the starting object to play.
     */
    @Nullable
    public abstract List<String> order();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder type(PlaybackType type);
        public abstract Builder order(List<String> order);

        public abstract Playback build();
    }
}