/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.List;

import auto.parcel.AutoParcel;

/**
 * The quiz.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Quiz.Builder.class)
public abstract class Quiz implements Parcelable {

    /**
     * The answer to the quiz.
     */
    @AutoParcel
    @JsonDeserialize(builder = AutoParcel_Quiz_Answer.Builder.class)
    public abstract static class Answer implements Parcelable {

        public static Builder builder() {
            return new AutoParcel_Quiz_Answer.Builder();
        }

        /**
         * The answer's content.
         */
        @NonNull
        public abstract String content();

        /**
         * Mark of correctness.
         */
        @NonNull
        public abstract Boolean correct();

        @AutoParcel.Builder
        @JsonPOJOBuilder(withPrefix = "")
        public abstract static class Builder {
            public abstract Builder content(String content);
            public abstract Builder correct(Boolean correct);

            public abstract Answer build();
        }
    }

    public static Builder builder() {
        return new AutoParcel_Quiz.Builder();
    }

    /**
     * Quiz's question.
     */
    @NonNull
    public abstract String question();

    /**
     * The comment for a correct answer.
     */
    @Nullable
    public abstract String comment();

    /**
     * Array of answers. The correct answer is marked.
     */
    @NonNull
    public abstract List<Answer> answers();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder question(String question);
        public abstract Builder comment(String comment);
        public abstract Builder answers(List<Answer> answers);

        public abstract Quiz build();
    }
}