/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.List;

import auto.parcel.AutoParcel;

/**
 * Schedule details.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Schedule.Builder.class)
public abstract class Schedule implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Schedule.Builder();
    }

    /**
     * Monday working hours.
     */
    @Nullable
    public abstract List<String> mon();

    /**
     * Tuesday working hours.
     */
    @Nullable
    public abstract List<String> tue();

    /**
     * Wednesday working hours.
     */
    @Nullable
    public abstract List<String> wed();

    /**
     * Thursday working hours.
     */
    @Nullable
    public abstract List<String> thu();

    /**
     * Friday working hours.
     */
    @Nullable
    public abstract List<String> fri();

    /**
     * Saturday working hours.
     */
    @Nullable
    public abstract List<String> sat();

    /**
     * Sunday working hours.
     */
    @Nullable
    public abstract List<String> sun();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder mon(List<String> mon);
        public abstract Builder tue(List<String> tue);
        public abstract Builder wed(List<String> wed);
        public abstract Builder thu(List<String> thu);
        public abstract Builder fri(List<String> fri);
        public abstract Builder sat(List<String> sat);
        public abstract Builder sun(List<String> sun);

        public abstract Schedule build();
    }
}