/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import java.util.List;

import auto.parcel.AutoParcel;

/**
 * The sponsor.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Sponsor.Builder.class)
public abstract class Sponsor implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Sponsor.Builder();
    }

    /**
     * UUID of sponsor object.
     */
    @NonNull
    public abstract String uuid();

    /**
     * Not localized name of sponsor.
     */
    @NonNull
    public abstract String name();

    /**
     * Web-site link.
     */
    @NonNull
    public abstract String website();

    /**
     * An array of images according to generic images format in izi.API.
     * The array keeps only one element with sponsor logo.
     */
    @NonNull
    public abstract List<Media> images();

    /**
     * Order of the element in the sponsors list, started from 1.
     * Sponsors list shall be shown in ascending order.
     */
    @NonNull
    public abstract Integer order();

    /**
     * Hash reflects a specific version of the sponsor.
     */
    @NonNull
    public abstract String hash();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder uuid(String uuid);
        public abstract Builder name(String name);
        public abstract Builder website(String website);
        public abstract Builder images(List<Media> images);
        public abstract Builder order(Integer order);
        public abstract Builder hash(String hash);

        public abstract Sponsor build();
    }
}