/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;
import travel.izi.api.model.enumeration.TriggerZoneType;

/**
 * Place where media content must be played.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_TriggerZone.Builder.class)
public abstract class TriggerZone implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_TriggerZone.Builder();
    }

    /**
     * Trigger zone type.
     */
    @NonNull
    public abstract TriggerZoneType type();

    /**
     * Comma separated list of polygon latitude, longitude, altitude.
     */
    @Nullable
    public abstract String polygonCorners();

    /**
     * Circle center latitude.
     */
    @Nullable
    public abstract Double circleLatitude();

    /**
     * Circle center longitude.
     */
    @Nullable
    public abstract Double circleLongitude();

    /**
     * Circle center altitude. This parameter has zero value for now
     * and reserved for future use and geocoding consistency.
     */
    @Nullable
    public abstract Double circleAltitude();

    /**
     * Circle radius in meters.
     */
    @Nullable
    public abstract Double circleRadius();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder type(TriggerZoneType type);
        public abstract Builder polygonCorners(String polygonCorners);
        public abstract Builder circleLatitude(Double circleLatitude);
        public abstract Builder circleLongitude(Double circleLongitude);
        public abstract Builder circleAltitude(Double circleAltitude);
        public abstract Builder circleRadius(Double circleRadius);

        public abstract TriggerZone build();
    }
}