/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * Quiz types.
 */
public enum QuizType {

    /**
     * A form of quiz when the end-user is asked to select one answer from an answers list where
     * one answer is marked as correct.
     */
    Choice("choice"),

    /**
     * A form of quiz when the end-user is asked to enter answer and API client checks
     * correctness form the list of possible answers.
     */
    Enter("enter");

    private final String value;

    private QuizType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, QuizType> STRING_MAPPING = new HashMap<>();

    static {
        for (QuizType via : QuizType.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    @SuppressWarnings("unused")
    @JsonCreator
    public static QuizType fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}