/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.service.constant;

/**
 * The API provides an ability to indicate certain sections to be included
 * into responses using parameters includes and except. It allows to improve
 * performance of API calls by receiving only the portion of the data that a client
 * is interested in. The following table reflects sections names (the parameters values)
 * that can be used for partial response.
 */
@SuppressWarnings("unused")
public final class ContentSectionModifier {

    /**
     * A request with `&amp;includes=all` will return everything in responses (above mentioned
     * sections) and an API client can indicate not required sections via `exclude` parameter in the
     * request in order to reduce response size. For example, `&amp;exclude=city,country,
     * publisher`, `&amp;exclude=children,download,location`.
     */
    public static final String ALL = "all";

    /**
     * None is indicated in includes parameter only `publisher`, `location` and `city_images`
     * will be included into response, when other from the table will be excluded.
     */
    public static final String NONE = "none";

    /**
     * City objects.
     */
    public static final String CITY = "city";

    /**
     * Images section of City (compact, full) object.
     */
    public static final String CITY_IMAGES = "city_images";

    /**
     * Children section from MTGObject full form.
     */
    public static final String CHILDREN = "children";

    /**
     * Museum’s collections.
     */
    public static final String COLLECTIONS = "collections";

    /**
     * Country object.
     */
    public static final String COUNTRY = "country";

    /**
     * Download section from/to MTGObject full form.
     */
    public static final String DOWNLOAD = "download";

    /**
     * Location section from/to MTGObject, City and Country sections.
     */
    public static final String LOCATION = "location";

    /**
     * News from/to MTGObject full form.
     */
    public static final String NEWS = "news";

    /**
     * Publisher from/to MTGObject.
     */
    public static final String PUBLISHER = "publisher";

    /**
     * References section from/to MTGObject.
     */
    public static final String REFERENCES = "references";

    /**
     * Reviews section from/to MTGObject.
     */
    public static final String REVIEWS = "reviews";

    /**
     * Country’s and City’s translations.
     */
    public static final String TRANSLATIONS = "translations";

    /**
     * Sponsors from/to MTGObject full form.
     */
    public static final String SPONSORS = "sponsors";

    /**
     * Route from/to MTGObject compact form.
     */
    public static final String ROUTE = "route";

}