/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.entity;

import android.os.Parcelable;
import android.support.annotation.NonNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

import auto.parcel.AutoParcel;

/**
 * Translation for country or city name.
 */
@AutoParcel
@JsonDeserialize(builder = AutoParcel_Translation.Builder.class)
public abstract class Translation implements Parcelable {

    public static Builder builder() {
        return new AutoParcel_Translation.Builder();
    }

    /**
     * Localized name.
     */
    @NonNull
    public abstract String name();

    /**
     * The language (ISO 639-1) of localization.
     */
    @NonNull
    public abstract String language();

    @AutoParcel.Builder
    @JsonPOJOBuilder(withPrefix = "")
    public abstract static class Builder {
        public abstract Builder name(String name);
        public abstract Builder language(String language);

        public abstract Translation build();
    }
}