/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.model.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * Tour placement.
 */
public enum Placement {

    /**
     * Indoor placement.
     */
    Indoor("indoor"),

    /**
     * Outdoor placement.
     */
    Outdoor("outdoor");

    private final String value;

    private Placement(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }

    private static final Map<String, Placement> STRING_MAPPING = new HashMap<>();

    static {
        for (Placement via : Placement.values()) {
            STRING_MAPPING.put(via.toString(), via);
        }
    }

    @SuppressWarnings("unused")
    @JsonCreator
    public static Placement fromValue(String value) {
        return STRING_MAPPING.get(value);
    }

}