/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.api.service;

import java.util.List;

import retrofit2.http.GET;
import rx.Observable;

/**
 * Endpoints for Languages.
 */
@SuppressWarnings("unused")
public interface LanguageService {

    /**
     * Returns the languages list of existent content in izi.TRAVEL Directory. The list can be
     * used for retrieving any reachable content using '&amp;languages=' parameter in API requests.
     * <p>NOTE: The list of languages has predefined order.</p>
     *
     * @return An array of languages where content exists in izi.TRAVEL Directory.
     */
    @GET("/languages/used")
    Observable<List<String>> usedLanguages();

    /**
     * Returns all available languages in izi.TRAVEL Directory for creation and publishing content,
     * however, only part of these languages is used, to get the list of languages where content
     * exists, you shall use {@link #usedLanguages()}.
     * <p>NOTE: The list of languages has predefined order.</p>
     *
     * @return An array of languages available in izi.TRAVEL Directory to publish content.
     */
    @GET("/languages/supported")
    Observable<List<String>> supportedLanguages();

}