/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import com.google.gson.annotations.SerializedName;
import travel.izi.sdk.model.IZITravelEntity;

/**
 * Language specific {@link FullMtgObject} content: texts, descriptions, media.
 */
@SuppressWarnings("unused")
public class Content implements IZITravelEntity {
    private static final long serialVersionUID = -7649775755228665105L;

    /**
     * Language (ISO 639-1) of this content item.
     */
    public String language;

    /**
     * Title.
     */
    public String title;

    /**
     * Shortened description.
     */
    public String summary;

    /**
     * Full description.
     */
    @SerializedName("desc")
    public String description;

    /**
     * News (typical for museum).
     */
    public String news;

    /**
     * MTGObject's playback algorithm settings. Specifies the way data inside MTGObject must be played.
     */
    public Playback playback;

    /**
     * Download links to offline packages for each supported mobile platform and combination of
     * image, audio and video data formats.
     */
    public Download download;

    /**
     * Array of images data.
     */
    public Media[] images;

    /**
     * Array of audio data.
     */
    public Media[] audio;

    /**
     * Array of video data.
     */
    public Media[] video;

    /**
     * Array of included object's content.
     */
    public CompactMtgObject[] children;

    /**
     * Array of included museum collection's content.
     */
    public CompactMtgObject[] collections;

    /**
     * Array of linked object's content.
     */
    public CompactMtgObject[] references;

    /**
     * Quiz data.
     */
    public Quiz quiz;

    /**
     * Number of children.
     */
    public int childrenCount;

    /**
     * Total audio duration.
     */
    public int audioDuration;

}