/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import com.google.gson.annotations.SerializedName;
import travel.izi.sdk.model.IZITravelEntity;

/**
 * This object contains a list of links to these packages:
 * <ol>
 * <li>Archives with MTGObject and its children data: JSON objects, images and audio files.
 * <li>Archive with map tiles for offline mapping.
 * <li>Archive with video files.
 * </ol>
 * <p>The `download` object is included into MTGObject only if at least one package exists.</p>
 */
@SuppressWarnings("unused")
public class Download implements IZITravelEntity {
    private static final long serialVersionUID = -3739763654442410883L;

    /**
     * Package of download.
     */
    public static class Package implements IZITravelEntity {
        private static final long serialVersionUID = -2995200961827501157L;

        /**
         * Direct link to download a package.
         */
        public String url;

        /**
         * File size (in bytes).
         */
        public int size;

        /**
         * MD5 hash from file. Actually this is ETag property for checking if content changed.
         */
        public String md5;

        /**
         * Date of the package generation.
         */
        @SerializedName("updated_at")
        public String updated;

    }

    /**
     * Package for iPhone 3GS and below (no retina display).
     */
    @SerializedName("ios-jpg:low-m4a-mp4")
    public Package iosLow;

    /**
     * Package for iPhone 4 and above (retina display).
     */
    @SerializedName("ios-jpg:high-m4a-mp4")
    public Package iosHigh;

    /**
     * Package for android devices with low and medium screen resolution (width &lt;= 480px).
     */
    @SerializedName("android-jpg:low-m4a-mp4")
    public Package androidLow;

    /**
     * Package for android devices with high and extra high screen resolution (width &gt; 480px).
     */
    @SerializedName("android-jpg:high-m4a-mp4")
    public Package androidHigh;

    /**
     * Package with videos for certain language.
     */
    public Package video;

    /**
     * Package with off-line map in mbtiles format for current MTGObject.
     */
    @SerializedName("map-mbtiles")
    public Package map;

}