/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;
import travel.izi.sdk.model.enumeration.Category;
import travel.izi.sdk.model.enumeration.MtgObjectType;

/**
 * Promoted or most popular published tours and museums.
 */
@SuppressWarnings("unused")
public class FeaturedObject implements IZITravelEntity {
    private static final long serialVersionUID = 70956846103293590L;

    /**
     * Universally Unique Identifier of the object.
     */
    public String uuid;

    /**
     * Object type (museum or tour).
     */
    public MtgObjectType type;

    /**
     * Category (typical for tour).
     */
    public Category category;

    /**
     * Title (name) defined by a featured content publisher.
     */
    public String title;

    /**
     * Optional sub-title (additional info) defined by a featured content publisher.
     * Examples: ‘BUS TOUR’, 'MUSEUM’, 'WALKING TOUR’.
     */
    public String subTitle;

    /**
     * A position of object in returned set (the order to show on a dashboard). Values: [1..10]
     */
    public int position;

    /**
     * Images of the content.
     * <p>NOTE: Contains only one object (first image).</p>
     */
    public Media[] images;

}